/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/


var thumbnailCount:Number	= 0;
var thumbs_arr:Array		= new Array();
var galleryDisplayed:Number;
var firstBuild:Boolean = true;
var thumbSelected:Number;

//==============================================================================================
//---- BUILD GALLERY
//==============================================================================================
function buildLibrary():Void {
	// build it only once
	if (!gallery_mc) {
		mainTL.createEmptyMovieClip("gallery_mc", mainTL.getNextHighestDepth());
	}
	
	if (!gallery_mc.thumbs_mc) {
		mainTL.gallery_mc.createEmptyMovieClip("thumbs_mc", 1);
	}
	
	// center it if it's first build
	if (firstBuild == true) {
		placeLogo();
		gallery_mc.slideTo((Stage.width/2) - (gallery_mc._width/2), (Stage.height/2) - (gallery_mc.mask_mc._height/2), animSpeed, "easeOutExpo");
	}
	
	// mask it
	maskGallery();

	// load them one by one
	if (thumbnailCount < library_obj.numNodes) {
		// first, attach loader
		if (!mainTL.loader_mc) {
			mainTL.attachMovie("mc.loader", "loader_mc", mainTL.getNextHighestDepth());
			mainTL.loader_mc._x = (Stage.width/2);
			mainTL.loader_mc._y = (Stage.height/2);
			
		}
		
		gallery_mc.thumbs_mc.attachMovie("mc.thumbnail", "thumb_" + thumbnailCount, thumbnailCount, {_x:-500, _y:Stage.height/2});		
		var thumbnailPath:String = dirPath + gallery_obj.thumbPath + "/" + library_obj.image[thumbnailCount].path;
		mcl.loadClip(thumbnailPath, gallery_mc.thumbs_mc["thumb_" + thumbnailCount].holder);
		
		// add thumbs to an array for easy referral in future
		thumbs_arr.push(gallery_mc.thumbs_mc["thumb_" + thumbnailCount]);
		
		thumbnailCount++;
		
	} else {	
		mainTL.loader_mc.removeMovieClip();			// remove loader
		firstBuild = false;

		// do it with onEnterFrame in case tween is still going on
		mainTL.onEnterFrame = function() {
			if (gallery_mc.isTweening() == false) {				
				placeButtons();								// place buttons if needed
				placeCopy();								// place copy
				buildMainNav();								// build main nav
				delete mainTL.onEnterFrame;				
			}
		}
	}
};

//==============================================================================================
//---- MOVIECLIP LOADER (THUMBNAILS)
//==============================================================================================
var mcl:MovieClipLoader = new MovieClipLoader();
var mcl_listener:Object = new Object();
mcl.addListener(mcl_listener);

mcl_listener.onLoadInit = function(mc:MovieClip):Void {
	mc = mc._parent;			// target thumb
	mc._alpha = 0;				// make it invisible
	positionThumb(mc);			// position it
	buildLibrary();			// build next
};


//==============================================================================================
//---- MOVIECLIP LOADER (LARGE)
//==============================================================================================
var mcl2:MovieClipLoader = new MovieClipLoader();
var mcl_listener2:Object = new Object();
mcl2.addListener(mcl_listener2);

mcl_listener2.onLoadProgress = function():Void {
	mainTL.attachMovie("mc.loader", "largeloader_mc", 50000, {_x:Stage.width/2, _y:Stage.height/2});
};

mcl_listener2.onLoadInit = function(mc:MovieClip):Void {

	// remove loader
	mainTL.largeloader_mc.removeMovieClip();
	
	// set mc's for quick access
	var holder:MovieClip 	= mc;
	var image:MovieClip 	= mc._parent;
	var border:MovieClip 	= mc._parent.border;
	
	// center holder
	holder._x = -holder._width/2;
	holder._y = -holder._height/2;

	// border
	border.colorTo(largeImageBorderColor, 0);
	border._width = border._height = 0;
	border.tween(["_width", "_height"], [holder._width + largeImageBorder, holder._height + largeImageBorder], 1, 'easeInOutExpo');

	// populate copy
	populateCopy(image, holder, thumbSelected, 1);
};

mcl_listener2.onLoadError = function(mc:MovieClip, errorCode:String):Void {
	if (errorCode == "URLNotFound") {
		throwError("The URL you requested could not be found.");
	}
};

//==============================================================================================
//---- FUNCTION TO POSITION ALL THUMBS
//==============================================================================================
function positionThumb(mc:MovieClip):Void {
	var quickNum:Number = Number(mc._name.substr(6));			// find out what number it is
	
	// color
	var thumbColor:Color = new Color(mc.bground);
	thumbColor.setRGB(thumbBorderColor);
	
	// border
	mc.bground._width 	= mc._width + (thumbnailBorder * 2);
	mc.bground._height 	= mc._height + (thumbnailBorder * 2);
	mc.holder._x = thumbnailBorder;
	mc.holder._y = thumbnailBorder;
	
	// highlight
	mc.highlight._alpha = 0;
	mc.highlight._x = mc.holder._x + mc.holder._width - mc.highlight._width;
	mc.highlight._y = mc.holder._y + mc.holder._height - mc.highlight._height;
	
	// placement
	var newX:Number = (quickNum % maxColumns) * (mc._width + thumbnailSpacer);
	var newY:Number = Math.floor(quickNum / maxColumns) * (mc._height + thumbnailSpacer);	
	mc._x = newX;
	mc._y = newY;
	
	// assign actions
	mc.holder.onRollOver 		= handleThumbRollOver;
	mc.holder.onRollOut 		= handleThumbRollOut;
	mc.holder.onRelease 		= handleThumbRelease;
	mc.holder.onReleaseOutside 	= handleThumbRelease;

	// fade in
	mc.fadeIn(animSpeed, 'easeInOutSine');
};


//==============================================================================================
//---- THUMBNAIL: HANDLE ROLLOVER
//==============================================================================================
function handleThumbRollOver():Void {
	if (this.viewed == true) {
		this.alphaTo(100, 1, 'easeOutExpo');
	}
	this._parent.highlight.plus.colorTo(linkColor, 0);
	this._parent.highlight.alphaTo(80, 0);
};

//==============================================================================================
//---- THUMBNAIL: HANDLE ROLLOUT
//==============================================================================================
function handleThumbRollOut():Void {
	if (this.viewed == true) {
		this.alphaTo(35, 1, 'easeOutExpo');
	}
	this._parent.highlight.plus.colorTo(linkColor, 0);
	this._parent.highlight.alphaTo(0, 1, 'easeOutExpo');
};

//==============================================================================================
//---- THUMBNAIL: HANDLE RELEASE
//==============================================================================================
function handleThumbRelease():Void {
	var which:String = this._parent._name;
	var num:Number = Number(which.substr(6));
	thumbSelected = num;
	
	if (!mainTL.large_mc) {
		mainTL.attachMovie("large.box", "bgroundBox_mc", mainTL.getNextHighestDepth(), {_alpha:0, _x:Stage.width/2, _y:Stage.height/2, _width:Stage.width, _height:Stage.height});
		mainTL.attachMovie("mc.large_image", "large_mc", mainTL.getNextHighestDepth(), {_visible:false, _x:Stage.width/2, _y:Stage.height/2});
		
		mainTL.bgroundBox_mc.colorTo(0x000000, 0);
		mainTL.bgroundBox_mc.alphaTo(80, 1, 'easeInOutSine');
		
		mcl2.loadClip(dirPath + gallery_obj.imagePath + "/" + library_obj.image[num].path, mainTL.large_mc.holder);
		
		enableThumbs(false);
		enableButtons(false);
		
		// mark as viewed
		this.viewed = true;
		this.alphaTo(35, 1, 'easeInOutSine');
		this._parent.highlight.alphaTo(0, 1, 'easeOutExpo');
	}
};


//==============================================================================================
//---- FUNCTION TO MASK GALLERY
//==============================================================================================
function maskGallery():Void {
	if (!mainTL.gallery_mc.mask_mc) {
		mainTL.gallery_mc.attachMovie("mc.mask", "mask_mc", 5);
	}
	mainTL.gallery_mc.mask_mc._width 	= gallery_mc.thumbs_mc._width;
	mainTL.gallery_mc.mask_mc._height 	= (maxRows * gallery_mc.thumbs_mc.thumb_0._height) + (thumbnailSpacer * maxRows);
	mainTL.gallery_mc.thumbs_mc.setMask(mainTL.gallery_mc.mask_mc);
};